#include <bits/stdc++.h>
#define MAX_N 1005

using namespace std;

int nextnode[MAX_N];
int cmpsize[MAX_N];

int dsufind(int x) {
    while(x != nextnode[x]) {
        x = nextnode[x];
    }
    return x;
}

void dsuunion(int a, int b) {
    a = dsufind(a);
    b = dsufind(b);
    if(a == b) {
        return ;
    }
    if(cmpsize[a] < cmpsize[b]) {
        nextnode[a] = b;
        cmpsize[b] += cmpsize[a];
    } else {
        nextnode[b] = a;
        cmpsize[a] += cmpsize[b];
    }
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);
    int n, q;
    cin >> n >> q;
    for(int i = 1; i <= n; i++) {
        cmpsize[i] = 1;
        nextnode[i] = i;
    }
    while(q--) {
        int t;
        cin >> t;
        int u, v;
        if(t == 1) {
            char c;
            cin >> u >> v >> c;
            dsuunion(u, v);
        } else {
            cin >> u >> v;
            if(dsufind(u) == dsufind(v)) {
                cout << "1\n";
            } else {
                cout << "0\n";
            }
        }
    }
    return 0;
}